#!/usr/bin/php -qC
<?php
// Hacks for PHP CGI
// see http://php.net/features.commandline for more information
set_time_limit(0);
ini_set("implicit_flush",true);
ini_set("output_buffering",0);
ini_set("html_errors",false);
ini_set("register_argc_argv",true);

// do not allow bot to run as root
if (getmyuid()==0) {
	die("Do not run the bot as root.");
}

// load class(es)
require("include/class.IQBot.php");
require("include/class.Database.php");
// load library
require("include/library.php");

// create objects
$bot = new IQBot;

// disable error reporting, and use custom
error_reporting(E_ALL ^ E_NOTICE);
set_error_handler("errorHandler");

// do not edit this, it is depended upon by some modules
$bot->version = "0.9.3";
// custom version information.. this is okay to edit if you modified your core in some way.
$bot->extraversion = "";

// get start time of bot (provided by wrapper or time())
$starttime=($argv[1]) ? $argv[1] : time();

// read start up switches
global $argv;
$IQargs=parseLine($argv);
$bot->info["configfile"]=$IQargs["c"] ? $IQargs["c"] : "config.php";

if (isset($IQargs["v"])) {
	echo "IQ {$bot->version}{$bot->extraversion}, an IRC bot framework by Matt Sparks (f0rked) - http://f0rked.com/IQ\n";
	exit(0);
}
if (isset($IQargs["h"]) || isset($IQargs["-help"])) {
	echo "IQ {$bot->version}{$bot->extraversion}\n";
	echo "Usage: $IQargs[0] [-c <filename>] [-d] [-h] [-v]\n";
	echo "  -c: use alternate config <filename>\n";
	echo "  -d: start in background mode (daemon) (requires process control support)\n";
	echo "  -h: show this help message\n";
	echo "  -v: print version and exit\n";
	exit(0);
}
	
if (isset($IQargs["d"])) {
	// bot was launched in daemon mode
	$corepid=getmypid();
	$daemon=true;
	echo "\nIQ {$bot->version}{$bot->extraversion} core PID: $corepid\n";
}
else {
	$daemon=false;
	set_titlebar("IQ {$bot->version}{$bot->extraversion}");
	$bot->log(ctext(">>> IQ {$bot->version}{$bot->extraversion} :: started: ".date("m-d-Y H:i:s",$starttime),"white"),false);
}

// Initialization: perform first load of modules
$bot->rehash();
$bot->execbind("init");

// process control
if (function_exists("pcntl_signal")) {
	declare(ticks = 1);
	$bot->debug("sighup handle: ".pcntl_signal(SIGHUP,"signalHandler"));
	$bot->debug("sigterm handle: ".pcntl_signal(SIGTERM,"signalHandler"));
}

// main while loop; keeps the bot running continuously
while (true) {
	// attempt a connection, assign to $conn
	$bot->infoLog("Connecting to {$bot->config["server"]}:{$bot->config["port"]}");
	if (!($bot->conn = $bot->connect($bot->config["server"],$bot->config["port"]))) {
		// failed to connect or timed out, sleep and try again
		$bot->problemLog("*** Could not connect to {$bot->config["server"]}:{$bot->config["port"]}, trying again in 10 seconds.");
		sleep(10);
		continue;
	}
	
	// connected
	$bot->send_queue=array();
	$bot->infoLog("Connected to {$bot->config["server"]}:{$bot->config["port"]}, registering...");
	$bot->execbind("connect",array("server" => $bot->config["server"],"port" => $bot->config["port"]));
	
	// register
	if ($bot->config["password"]) {
		$bot->raw("PASS {$bot->config["password"]}",false);
	}
	$bot->raw("NICK {$bot->config["nickname"]}",false);
	$bot->raw("USER IQ 8 * :{$bot->config["realname"]}",false);
	
	// set up channel information
	$bot->info["in_channels"]=array();
	$bot->info["channel_users"]=array();
	$bot->info["channel_topics"]=array();
	$bot->info["user_counts"]=array();
	
	// setup initial lag values
	$bot->info["lagcheck"]=microtime();
	$bot->info["lagcheck_reply"]=$bot->info["lagcheck"];
	$bot->replyto("lagcheck");
	
	// set timeout for irc connection
	// amount of time to wait for data.. setting this too low is bad (eats up CPU)
	stream_set_timeout($bot->conn,0,200000); // second and third arguments: seconds,usec

	// while loop for IRC connection
	while (true) {
		$in=trim(fgets($bot->conn,4096));
		$bot->debug($in);
		
		// flush send queue/buffer
		$bot->raw();
		
		// join channels
		if ($bot->config["chans"] && $bot->info["registered"] && !$bot->replyto("join_channels",$bot->config["joindelay"])) {
			$cstr="";
			$kstr="";
			foreach($bot->info["my_channels"] as $foo) {
				if (!in_array($foo,$bot->info["in_channels"])) {
					$cstr.="$foo,";
					$kstr.=($bot->config["keys"][$foo]) ? $bot->config["keys"][$foo]."," : "x,";
				}
			}
			if (substr($cstr,0,-1)) {
				$bot->infoLog("Attempting to join channels: ".str_replace(",",", ",substr($cstr,0,-1)));  
				$bot->raw("JOIN ".substr($cstr,0,-1)." ".substr($kstr,0,-1));
			}
			unset($chan,$foo,$kstr,$cstr);
		}	
				
		// handle raws & events
		if (is_numeric(gettok($in,1))) {
			$bot->handleRaw(gettok($in,1),$in);
		}
		elseif (!is_numeric(gettok($in,1)) && gettok($in,1)) {
			$bot->handleEvent(gettok($in,1),$in);
		}
		
		// keep alive with ping/pong action (disable buffering)
		if (gettok($in,0)=="PING") {
			$bot->raw("PONG ".gettok($in,1),false);
		}
		
		// Throttle the bot so we don't flood the server
		if (gettok($in,0)=="ERROR" && strpos($in,"Trying to reconnect too fast")) {
			$bot->problemLog("Reconnecting too fast, waiting 20 seconds");
			sleep(20);
		}
		
		// process binds of "all" type
		$bot->execbind("all",array("in" => $in));
		
		/* no non-idle stuff beyond this point in the while() */

		if (!$in) {
			$foo=stream_get_meta_data($bot->conn);
			if ($foo["timed_out"]) {
				// timed out, obviously.
				if ($bot->info["registered"] && $bot->info["mynick"] != $bot->config["nickname"] && !$bot->replyto("getnick",180)) {
					$bot->log("({$bot->info["mynick"]}) Attempting to gain back primary nickname");
					$bot->raw("NICK {$bot->config["nickname"]}");
				}
				
				// check server lag
				if (!$bot->replyto("lagcheck",$bot->config["lagdelay"])) { 
					if ($bot->info["lagcheck_reply"] != $bot->info["lagcheck"]) {
						// didn't get last lagcheck response.. might be dead
						$bot->log("Disconnecting due to lack of a lag response ({$bot->info["lagcheck_reply"]} != {$bot->info["lagcheck"]})");
						fclose($bot->conn);
						break;
					}
					else {
						$bot->info["lagcheck"]=microtime();
						$bot->msg($bot->info["mynick"],chr(1)."LAG {$bot->info["lagcheck"]}".chr(1),0,false);
					}
				}
				
				$bot->execbind("idle");
				continue;
			}
			if ($foo["eof"]) {
				// socket reached EOF, break so bot can disconnect
				break;
			}
		}		
	}
	if (!$daemon) { set_titlebar("IQ {$bot->version}{$bot->extraversion}"); }
	$bot->log("Diconnected. Sleeping for {$bot->config["reconnect_sleep"]} second(s).");
	$bot->execbind("disconnect");
	sleep($bot->config["reconnect_sleep"]);
}
?>
