<?php
// Automode module for IQ (http://f0rked.com/IQ)
// version: 1.0
// author: f0rked
// This script is a more advanced version of the original autoOp module.
// It will intelligently keep track of operators, voices, and half-operators in all channels
// that the bot monitors, and will restore the mode when the users return.

$this->bind("init","","","","automode_init");
$this->bind("mode","","","","automode_modecheck");
$this->bind("join","","","","automode_joincheck");
$this->bind("kick","","","","automode_kickcheck");
$this->bind("all","","","","automode_pushmode");

// Executed when the bot starts. Load the modes list.
$this->functions["automode_init"]=create_function('','
	global $bot;
	$bot->data["automode_list"]=array();
	$bot->functions["automode_loadlist"]();
');

// Function used to make the regexp masks for future matching
$this->functions["automode_makemask"]=create_function('$args','
	global $bot;
	$host=$args[0];
	$ident=$args[1];
	
	// Fix host
	$foo=split("\.",$host);
	if (count($foo) <= 2) {
		// host is something like "f0rked.com" and we cannot make the mask *.com
	}
	else {
		if (is_numeric($foo[count($foo)-1])) {
			// looks like an ip address, mask last segment
			$host=str_replace(".","\.",substr($host,0,strlen($host)-strlen($foo[count($foo)-1])))."[0-9]{1,3}";
		}
		else {
			// looks like a hostname with more than 2 segments, mask first segment
			$host=".+".str_replace(".","\.",substr($host,strlen($foo[0])));
		}
	}
				
	if ($ident && $host) {
		$mask=".+!.*$ident@$host";
		return $mask;
	}
	else {
		return 0;
	}
');		

// Executed on mode changes.. maintains the mode list.
$this->functions["automode_modecheck"]=create_function('$args','
	global $bot;
	
	// $mode is the mode given (o,v,h)
	// $nick is the handle of the user to whom the mode was given
	// $target is the target channel on which the mode was given
	// $mask contains a reasonable mask for the user

	// handle added modes
	foreach ($args["addmodes"] as $array) {
		foreach (array_keys($array) as $mode) {
			$nick=$array[$mode];
			$target=$args["target"];
		
			$ident=str_replace("~","",$bot->info["channel_users"][$target][$nick]["ident"]);
			$host=$bot->info["channel_users"][$target][$nick]["host"];
			$mask=$bot->functions["automode_makemask"](array($host,$ident));	
							
			if (in_array($mode,array_keys($bot->info["chan_user_modes"])) && $nick != $bot->info["mynick"]) {
				// op, voice, or halfop was given, and not to the bot
				// if target $nick has a reasonable mask, save the mode to the modelist
				if ($mask) {
					if (!is_array($bot->data["automode_list"][$target])) {
						$bot->data["automode_list"][$target]=array();
					}
					if (!is_array($bot->data["automode_list"][$target][$mode])) {
						$bot->data["automode_list"][$target][$mode]=array();
					}
					if (!in_array($mask,$bot->data["automode_list"][$target][$mode])) {
						$bot->data["automode_list"][$target][$mode][]=$mask;
						$bot->infoLog("Added mask \'$mask\' to the automode list of $target for mode +$mode");
						$bot->functions["automode_savelist"](array("quiet"=>1));
					}
				}
				else {
					$bot->debug("[automode] Mask returned nothing; host: $host; ident: $ident");
				}
			}
		}
	}
	
	// handle removed modes
	foreach ($args["remmodes"] as $array) {
		foreach (array_keys($array) as $mode) {
			$nick=$array[$mode];
			$target=$args["target"];
		
			$ident=str_replace("~","",$bot->info["channel_users"][$target][$nick]["ident"]);
			$host=$bot->info["channel_users"][$target][$nick]["host"];
			$mask=$bot->functions["automode_makemask"](array($host,$ident));	
		
			if (in_array($mode,array_keys($bot->info["chan_user_modes"])) && $nick != $bot->info["mynick"]) {
				// $mode is taken
				if ($mask) {
					if (in_array($mask,$bot->data["automode_list"][$target][$mode])) {
						$key=array_search($mask,$bot->data["automode_list"][$target][$mode]);
						unset($bot->data["automode_list"][$target][$mode][$key]);
						$bot->infoLog("Removed mask \'$mask\' from the automode list of $target for mode +$mode");
						$bot->functions["automode_savelist"](array("quiet"=>1));
					}
				}
			}
		}
	}
');

// Executed when users join a channel the bot is monitoring
$this->functions["automode_joincheck"]=create_function('$args','
	global $bot;
	$target=$args["target"];
	$hostmask="{$args["nick"]}!{$args["ident"]}@{$args["host"]}";
	$addmodes="";
	if ($bot->data["automode_list"][$target]) {
		foreach (array_keys($bot->info["chan_user_modes"]) as $mode) {
			if (!is_array($bot->data["automode_list"][$target][$mode])) {
				continue;
			}
			foreach ($bot->data["automode_list"][$target][$mode] as $foohost) {
				// $foohost is a mask in the most list
				if (ereg($foohost,$hostmask) && $args["nick"] != $bot->info["mynick"]) {
					// mode entry exists for $hostmask on $target for mode $mode
					if (!ereg($mode,$args["flags"])) {
						$addmodes.=$mode;
					}
					else {
						$bot->debug("Ignoring mode +$mode for {$args["nick"]}, user already has flag");
					}
				}
			}
		}
		if ($addmodes) {
			$bot->infoLog("Matched mode (+$addmodes) for {$args["nick"]} ($hostmask) on $target. Attempting to assign.");
			$bot->info["automode_queue"][$target][]=array("nick" => $args["nick"], "modes" => $addmodes);
			$bot->functions["automode_pushmode"]($args);
		}
	}
');

$this->functions["automode_kickcheck"]=create_function('$args','
	global $bot;
	$target=$args["target"];
	$ident=str_replace("~","",$bot->info["channel_users"][$target][$args["knick"]]["ident"]);
	$host=$bot->info["channel_users"][$target][$args["knick"]]["host"];
	$mask=$bot->functions["automode_makemask"](array($host,$ident));
	if ($mask) {
		foreach (array_keys($bot->info["chan_user_modes"]) as $mode) {
			if (!is_array($bot->data["automode_list"][$target][$mode])) {
				continue;
			}
			if (in_array($mask,$bot->data["automode_list"][$target][$mode])) {
				$key=array_search($mask,$bot->data["automode_list"][$target][$mode]);
				unset($bot->data["automode_list"][$target][$mode][$key]);
				$bot->infoLog("Removed mask \'$mask\' from the automode list of $target for mode +$mode");
			}
		}
		$bot->functions["automode_savelist"](array("quiet"=>1));
	}
');

$this->functions["automode_pushmode"]=create_function('$args','
	global $bot;
	
	if (!count($bot->info["automode_queue"])) {
		return;
	}

	//print_r($bot->info["automode_queue"]);
	
	// only try to set modes once per second.. this allows the bot to make the most out of
	// netsplits, and set multiple modes per second rather than just one.
	if (!$bot->replyto("automode_pushmode_check",1) || $args["force"]) {
		foreach ($bot->info["in_channels"] as $foochan) {
			$nicks=array();
			$modes=array();
			$modesperline=$bot->serverinfo["modes"] ? $bot->serverinfo["modes"] : 3;
			$i=0;

			if (is_array($bot->info["automode_queue"][$foochan])) {
				foreach (array_keys($bot->info["automode_queue"][$foochan]) as $key) {
					$ar=$bot->info["automode_queue"][$foochan][$key];
					if (is_array($ar) && strlen($ar["modes"])+$i<=6) {
						$i+=strlen($ar["modes"]);
						for ($x=0;$x<=strlen($ar["modes"])-1;$x++) {
							$foo=substr($ar["modes"],$x,1);
							$nicks[]=$ar["nick"];
							$modes[]=$foo;
						}		

						unset($bot->info["automode_queue"][$foochan][$key]);					
					}
					if ($i==$modesperline) {
						break;
					}
				}
			}		
			
			if (count($nicks) && $bot->info["channel_users"][$foochan][$bot->info["mynick"]]["modes"]["o"]) {
				$bot->debug("automode: setting +".join("",$modes)." ".join(" ",$nicks)." on $foochan.");
				$bot->mode($foochan,"+".join("",$modes)." ".join(" ",$nicks));
			}
			if (!count($bot->info["automode_queue"][$foochan])) {
				unset($bot->info["automode_queue"][$foochan]);
			}
		}
	}
');

$this->functions["automode_loadlist"]=create_function('$args=array("quiet"=>0)','
	global $bot;
	if (file_exists("data/automode_list")) {
		if ($bot->data["automode_list"]=unserialize(file_get_contents("data/automode_list"))) {
			if (!$args["quiet"]) {
				$bot->infoLog("Loaded saved automode list");
			}
		}
		else {
			$bot->problemLog("Failed to load saved automode list");
		}
	}
');

$this->functions["automode_savelist"]=create_function('$args=array("quiet"=>0)','
	global $bot;
	$output=serialize($bot->data["automode_list"]);
	$fp=@fopen("data/automode_list","w");
	if ($fp) {
		fputs($fp,$output);
		fclose($fp);
		if (!$args["quiet"]) {
			$bot->infoLog("Automode list successfully saved.");
		}
	}
	else {
		$bot->problemLog("Could not open data/automode_list for writing. Automode list was not saved.");
	}
');
	
$this->infoLog("Automode Module Loaded");
?>
